/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.RenderWorldEvent;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ElevatorGroupRenderer {
    public static final double RENDER_DISTANCE = 260100.0;

    @SubscribeEvent
    public static void onRender(RenderWorldEvent e) {
        LazyOptional optional = ClientUtils.getWorld().getCapability(ElevatorGroupCapability.CAPABILITY);
        if (!optional.isPresent()) {
            return;
        }
        ElevatorGroupCapability groups = (ElevatorGroupCapability)optional.resolve().get();
        e.getPoseStack().m_85836_();
        Vec3 camera = RenderUtils.getCameraPosition();
        e.getPoseStack().m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
        for (ElevatorGroup group : groups.getGroups()) {
            BlockPos elevatorPos = new BlockPos((double)group.x, group.getCurrentY(), (double)group.z);
            if (!(elevatorPos.m_123331_((Vec3i)Minecraft.m_91087_().f_91074_.m_142538_()) < 260100.0)) continue;
            ElevatorGroupRenderer.renderGroup(e.getPoseStack(), group, (MultiBufferSource)RenderUtils.getMainBufferSource(), e.getPartialTicks());
        }
        e.getPoseStack().m_85849_();
    }

    public static void renderGroup(PoseStack matrixStack, ElevatorGroup group, MultiBufferSource buffer, float partialTicks) {
        if (ClientUtils.getMinecraft().m_91290_().m_114377_()) {
            ElevatorGroupRenderer.renderGroupCageOutlines(matrixStack, group);
        }
        if (!group.isMoving()) {
            return;
        }
        ElevatorCage cage = group.getCage();
        double lastY = group.getLastY();
        double currentY = group.getCurrentY();
        double renderY = lastY + (currentY - lastY) * (double)partialTicks;
        Vec3 startPos = group.getCageAnchorPos(renderY);
        BlockPos topPos = new BlockPos((double)group.x, renderY, (double)group.z).m_5484_(group.facing, (int)Math.ceil((float)group.getCageDepth() / 2.0f));
        int currentLight = LevelRenderer.m_109541_((BlockAndTintGetter)group.world, (BlockPos)topPos);
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    if (cage.blockStates[x][y][z] == null) continue;
                    matrixStack.m_85836_();
                    matrixStack.m_85837_(startPos.f_82479_ + (double)x, startPos.f_82480_ + (double)y, startPos.f_82481_ + (double)z);
                    ClientUtils.getBlockRenderer().renderSingleBlock(cage.blockStates[x][y][z], matrixStack, buffer, currentLight, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
                    matrixStack.m_85849_();
                }
            }
        }
        if (ClientUtils.getMinecraft().m_91290_().m_114377_()) {
            RenderUtils.renderBox((PoseStack)matrixStack, (AABB)new AABB(startPos, startPos.m_82520_((double)group.getCageSizeX(), (double)group.getCageSizeY(), (double)group.getCageSizeZ())), (float)1.0f, (float)0.0f, (float)0.0f);
            RenderUtils.renderShape((PoseStack)matrixStack, (VoxelShape)cage.shape.m_83216_(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_), (float)0.19215687f, (float)0.8784314f, (float)0.85882354f);
            RenderUtils.resetState();
        }
    }

    public static void renderGroupCageOutlines(PoseStack matrixStack, ElevatorGroup group) {
        for (int floor = 0; floor < group.getFloorCount(); ++floor) {
            BlockPos anchorPos = group.getCageAnchorBlockPos(group.getFloorYLevel(floor));
            AABB cageArea = new AABB(anchorPos, anchorPos.m_142082_(group.getCageSizeX(), group.getCageSizeY(), group.getCageSizeZ()));
            cageArea.m_82400_(0.01);
            RenderUtils.enableDepthTest();
            RenderUtils.renderBox((PoseStack)matrixStack, (AABB)cageArea, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.resetState();
        }
    }
}

